/*:ja
 * @plugindesc
 * [v0.1.0] ポップアップ通知を表示する機能を追加します。
 * 
 * @author かめお (Kamesoft)
 *
 * @param Display duration
 * @default 180
 * @desc 通知表示時間をフレーム単位で指定します。
 *
 * @param Display position
 * @default 0
 * @desc
 *  通知を表示する位置です。
 *  0: 左上  1: 右上  2: 左下  3: 右下
 *
 * @param Face image size
 * @default 64
 * @desc 通知用顔グラフィックのサイズをピクセル単位で指定します。
 *
 * @param Font size
 * @default 18
 * @desc 通知のフォントサイズを指定します。
 *
 * @param Max notification count
 * @default 4
 * @desc 同時に表示できる通知の最大数です。
 *
 * @param Notification SE
 * @default Saint5
 * @require 1
 * @dir audio/se/
 * @type file
 * @desc 通知表示時に演奏する SE のファイル名です。 audio/se から読み込みます。
 *
 * @param Notification SE param
 * @default 100, 50
 * @desc
 * 書式: ボリューム, ピッチ, パン
 * 通知表示時に演奏する SE のパラメータです。ピッチ以降省略可。
 *
 * @param Notification skin
 * @default QuickNotificationSkin
 * @require 1
 * @dir img/system/
 * @type file
 * @desc 通知の表示に使用するスキン画像です。 img/system から読み込みます。
 *
 *
 * @help
 *
 * ■ プラグインコマンド
 *
 * QuickNotification enable     # 通知を有効にします。
 * QuickNotification disable    # 通知を無効にします。
 * QuickNotification register   # 次の「文章の表示」コマンドで通知を登録します。
 *
 */
